# 恐龙
恐龙是古老而奇伟的生物，可以养殖以获取远古骨头。

不幸的是，恐龙很久以前就灭绝了，所以我们现在最多只能打扮成恐龙。
为此，你收到了新的恐龙帽。

帽子可以用以下方式装备：
`change_hat(Hats.Dinosaur_Hat)`

很可惜，它看起来和广告上的不太一样……

如果装备了恐龙帽且有足够的仙人掌，则会自动购买一颗[苹果](objects/apple)并将其放置在无人机下方。
当无人机在苹果上方并再次移动时，便会吃掉苹果，同时尾巴增长一节。如果你还有足够的仙人掌，一颗新的苹果将被购买并放置在一个随机位置。
如果苹果想生成的位置已经种植了其他东西，则无法生成。

恐龙的尾巴会拖在无人机后面，填满无人机之前移动过的地块。如果无人机试图移动到尾巴上方，`move()` 将会失败并返回 `False`。
在移动过程中，尾巴的最后一节会移开，所以你可以移动到它原来的位置上。但是，如果尾巴填满了整个农场，你将无法再移动。所以你可以通过检查是否无法移动来判断尾巴是否已经长到最大。

在苹果上使用 `measure()` 将返回下一个苹果的位置，形式为一个元组。

`next_x, next_y = measure()`

当通过装备不同的帽子再次卸下这顶帽子时，便会收获尾巴。
你将获得等于尾巴长度平方数量的骨头。因此，若尾巴长度为 `n`，则将获得 `n**2` 根 `Items.Bone`。
例如：
长度 1 => 1 根骨头
长度 2 => 4 根骨头
长度 3 => 9 根骨头
长度 4 => 16 根骨头
长度 16 => 256 根骨头
长度 100 => 10000 根骨头

恐龙帽非常重，所以装备后会使 `move()` 消耗 400 ticks 而不是 200。然而，每当你捡起一颗苹果，`move()` 使用的 ticks 数量便会减少 3%（向下取整），因为尾巴变长可以帮助移动。

以下循环打印出吃掉任意数量苹果后 `move()` 使用的 ticks 数量：

`ticks = 400
for i in range(100):
    print("吃掉 ", i, " 颗苹果后的 ticks: ", ticks)
    ticks -= ticks * 0.03 // 1`

你只有一顶恐龙帽，所以只有一架无人机可以佩戴它。

<spoiler=显示提示 1>如果始终沿着覆盖整个场地的同一路径移动，那么每次都能轻松地得到一条覆盖整个场地的尾巴蛇。虽然效率不高，但确实可行。
完全遍历一个非常大的农场可能需要很长时间，而且你实际上可能并不需要那么多骨头。不妨使用 `set_world_size()` 将农场改为更方便覆盖的大小。</spoiler>